/*
 * Decompiled with CFR 0.152.
 */
package jade.core.faultRecovery;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.BaseService;
import jade.core.Filter;
import jade.core.IMTPException;
import jade.core.MainContainer;
import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.ServiceException;
import jade.core.VerticalCommand;
import jade.core.faultRecovery.PersistentStorage;
import jade.util.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Map;

public class FaultRecoveryService
extends BaseService {
    public static final String NAME = "jade.core.faultRecovery.FaultRecovery";
    public static final String CLEAN_STORAGE = "jade_core_faultRecovery_FaultRecoveryService_cleanstorage";
    public static final String PERSISTENT_STORAGE_CLASS = "jade_core_faultRecovery_FaultRecoveryService_persistentstorage";
    public static final String PERSISTENT_STORAGE_CLASS_DEFAULT = "jade.core.faultRecovery.FSPersistentStorage";
    private AgentContainer myContainer;
    private MainContainer myMain;
    private Filter inpFilter;
    private Filter outFilter;
    private PersistentStorage myPS;
    private NodeSerializer nodeSerializer;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.myContainer = ac;
        this.myMain = this.myContainer.getMain();
        if (this.myMain != null) {
            this.inpFilter = new MainCommandIncomingFilter();
            this.outFilter = new MainCommandOutgoingFilter();
            this.nodeSerializer = new NodeSerializer();
            String psClass = p.getParameter(PERSISTENT_STORAGE_CLASS, PERSISTENT_STORAGE_CLASS_DEFAULT);
            try {
                this.myLogger.log(Logger.CONFIG, "Loading PersistentStorage of class " + psClass);
                this.myPS = (PersistentStorage)Class.forName(psClass).newInstance();
                this.myPS.init(p);
                boolean cleanStorage = p.getBooleanProperty(CLEAN_STORAGE, false);
                if (!cleanStorage) return;
                this.myLogger.log(Logger.CONFIG, "Clearing PersistentStorage ...");
                this.myPS.clear();
                return;
            }
            catch (Exception e) {
                String msg = "Error initializing PersistentStorage. ";
                this.myLogger.log(Logger.SEVERE, msg, e);
                if (this.myPS == null) throw new ProfileException(msg, e);
                this.myPS.close();
                throw new ProfileException(msg, e);
            }
        } else {
            this.inpFilter = new ContainerCommandIncomingFilter();
        }
    }

    public void boot(Profile p) throws ServiceException {
        if (this.myMain != null) {
            try {
                String oldAddress = this.myPS.getLocalAddress();
                String newAddress = this.myContainer.getServiceManager().getLocalAddress();
                this.myPS.storeLocalAddress(newAddress);
                if (oldAddress != null) {
                    String name;
                    this.myLogger.log(Logger.INFO, "Initiating fault recovery procedure...");
                    Map allNodes = this.myPS.getAllNodes(false);
                    Iterator it = allNodes.keySet().iterator();
                    while (it.hasNext()) {
                        name = (String)it.next();
                        this.checkNode(name, (byte[])allNodes.get(name), oldAddress, newAddress);
                    }
                    allNodes = this.myPS.getAllNodes(true);
                    it = allNodes.keySet().iterator();
                    while (it.hasNext()) {
                        name = (String)it.next();
                        this.checkNode(name, (byte[])allNodes.get(name), oldAddress, newAddress);
                    }
                    this.myLogger.log(Logger.INFO, "Fault recovery procedure completed.");
                }
            }
            catch (Exception e) {
                String msg = "Error recovering from previous fault. ";
                this.myLogger.log(Logger.SEVERE, msg, e);
                throw new ServiceException(msg, e);
            }
        }
    }

    public void shutdown() {
        block2: {
            if (this.myPS == null) break block2;
            try {
                this.myPS.clear();
                this.myPS.close();
            }
            catch (Exception e) {
                this.myLogger.log(Logger.WARNING, "Unexpected error clearing PersistentStorage. ", e);
            }
        }
    }

    public String getName() {
        return NAME;
    }

    public Filter getCommandFilter(boolean direction) {
        if (!direction) {
            return this.inpFilter;
        }
        return this.outFilter;
    }

    private void checkNode(String name, byte[] nn, String oldAddress, String currentAddress) {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Recovering node " + name + " ...");
        }
        Node node = null;
        try {
            node = this.nodeSerializer.deserialize(nn);
            node.platformManagerDead(oldAddress, currentAddress);
            this.myLogger.log(Logger.INFO, "Node " + name + " recovered.");
        }
        catch (IMTPException imtpe) {
            this.myLogger.log(Logger.INFO, "Node " + name + " unreachable. It has likely been killed in the meanwhile");
            try {
                this.myPS.removeNode(node.getName());
            }
            catch (Exception ex) {
                this.myLogger.log(Logger.WARNING, "Cannot remove node " + node.getName() + " from persistent storage. ", ex);
            }
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Error recovering node " + name + ". ", e);
        }
    }

    private void handleNewNode(NodeDescriptor dsc) throws Exception {
        Node node = dsc.getNode();
        if (!node.hasPlatformManager()) {
            byte[] nn = this.nodeSerializer.serialize(node);
            this.myPS.storeNode(node.getName(), dsc.getParentNode() != null, nn);
            this.myLogger.log(Logger.FINE, "Node " + node.getName() + " added to persistent storage.");
        }
    }

    private void handleDeadNode(NodeDescriptor dsc) throws Exception {
        Node node = dsc.getNode();
        if (!node.hasPlatformManager()) {
            this.myPS.removeNode(node.getName());
            this.myLogger.log(Logger.FINE, "Node " + node.getName() + " removed from persistent storage.");
        }
    }

    private void handleNodeUnreachable(Node node) throws Exception {
        if (!node.hasPlatformManager()) {
            this.myPS.setUnreachable(node.getName());
            this.myLogger.log(Logger.FINE, "Node " + node.getName() + " marked as unreachable.");
        }
    }

    private void handleNodeReachable(Node node) throws Exception {
        if (!node.hasPlatformManager()) {
            this.myPS.resetUnreachable(node.getName());
            this.myLogger.log(Logger.FINE, "Node " + node.getName() + " marked as reachable.");
        }
    }

    private void handleOrphanNode(String nodeName) {
        this.myLogger.log(Logger.INFO, "Recovering orphan node " + nodeName + "...");
    }

    private void handleReattached() {
        this.myLogger.log(Logger.INFO, "Re-adding all local agents to recovered main container...");
        AID[] ids = this.myContainer.agentNames();
        int i = 0;
        while (i < ids.length) {
            AID id = ids[i];
            Agent agent = this.myContainer.acquireLocalAgent(id);
            if (agent != null) {
                if (this.myLogger.isLoggable(Logger.CONFIG)) {
                    this.myLogger.log(Logger.CONFIG, "Re-adding agent " + id.getName());
                }
                try {
                    this.myContainer.initAgent(agent.getAID(), agent, null, null);
                }
                catch (Exception e) {
                    this.myLogger.log(Logger.SEVERE, "Error reattaching agent " + id.getName() + ". ", e);
                }
            }
            this.myContainer.releaseLocalAgent(id);
            ++i;
        }
    }

    public class NodeSerializer {
        public byte[] serialize(Node n) throws Exception {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream encoder = new ObjectOutputStream(out);
            encoder.writeObject(n);
            return out.toByteArray();
        }

        public Node deserialize(byte[] bb) throws Exception {
            ByteArrayInputStream inp = new ByteArrayInputStream(bb);
            ObjectInputStream decoder = new ObjectInputStream(inp);
            return (Node)decoder.readObject();
        }
    }

    private class ContainerCommandIncomingFilter
    extends Filter {
        private ContainerCommandIncomingFilter() {
        }

        public boolean accept(VerticalCommand cmd) {
            String name = cmd.getName();
            try {
                if (name.equals("Reattached")) {
                    FaultRecoveryService.this.handleReattached();
                }
            }
            catch (Exception e) {
                FaultRecoveryService.this.myLogger.log(Logger.WARNING, "Error processing command " + name + ". ", e);
            }
            return true;
        }
    }

    private class MainCommandOutgoingFilter
    extends Filter {
        private MainCommandOutgoingFilter() {
        }

        public boolean accept(VerticalCommand cmd) {
            String name = cmd.getName();
            try {
                if (name.equals("Node-Unreachable")) {
                    FaultRecoveryService.this.handleNodeUnreachable((Node)cmd.getParams()[0]);
                } else if (name.equals("Node-Unreachable")) {
                    FaultRecoveryService.this.handleNodeReachable((Node)cmd.getParams()[0]);
                } else if (name.equals("Orphan-Node")) {
                    FaultRecoveryService.this.handleOrphanNode((String)cmd.getParams()[0]);
                }
            }
            catch (Exception e) {
                FaultRecoveryService.this.myLogger.log(Logger.WARNING, "Error processing command " + name + ". ", e);
            }
            return true;
        }
    }

    private class MainCommandIncomingFilter
    extends Filter {
        private MainCommandIncomingFilter() {
        }

        public boolean accept(VerticalCommand cmd) {
            String name = cmd.getName();
            try {
                if (name.equals("New-Node")) {
                    FaultRecoveryService.this.handleNewNode((NodeDescriptor)cmd.getParams()[0]);
                } else if (name.equals("Dead-Node")) {
                    FaultRecoveryService.this.handleDeadNode((NodeDescriptor)cmd.getParams()[0]);
                }
            }
            catch (Exception e) {
                FaultRecoveryService.this.myLogger.log(Logger.WARNING, "Error processing command " + name + ". ", e);
            }
            return true;
        }
    }
}

